

<?php $__env->startSection('title', 'Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="notifications-page">
    <div class="notifications-container">
        <div class="notifications-header">
            <h1>Notifications</h1>
            
            <?php if($notifications->total() > 0): ?>
                <div class="notifications-actions">
                    <form action="<?php echo e(route('notifications.mark-all-read')); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-primary">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <polyline points="20,6 9,17 4,12"></polyline>
                            </svg>
                            Mark All Read
                        </button>
                    </form>
                    
                    <form action="<?php echo e(route('notifications.destroy-all')); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" 
                                onclick="return confirm('Are you sure you want to delete all notifications?')"
                                class="btn btn-danger">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <polyline points="3,6 5,6 21,6"></polyline>
                                <path d="m19,6v14a2,2 0 0,1 -2,2H7a2,2 0 0,1 -2,-2V6m3,0V4a2,2 0 0,1 2,-2h4a2,2 0 0,1 2,2v2"></path>
                            </svg>
                            Delete All
                        </button>
                    </form>
                </div>
            <?php endif; ?>
        </div>

        <?php if($notifications->count() > 0): ?>
            <div class="notifications-content">
                <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="notification-card <?php echo e($notification->read_at ? '' : 'unread'); ?>">
                        <div class="notification-main">
                            <?php if(isset($notification->data['reactor_avatar']) || isset($notification->data['replier_avatar'])): ?>
                                <img src="<?php echo e($notification->data['reactor_avatar'] ?? $notification->data['replier_avatar']); ?>" 
                                     alt="Avatar" 
                                     class="notification-avatar">
                            <?php else: ?>
                                <div class="notification-avatar" style="background: var(--dark-gray-lightest); display: flex; align-items: center; justify-content: center;">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                </div>
                            <?php endif; ?>
                            
                            <div class="notification-details">
                                <div class="notification-message">
                                    <?php echo e($notification->data['message']); ?>

                                    <?php if(isset($notification->data['reaction_emoji'])): ?>
                                        <span class="reaction-emoji"><?php echo e($notification->data['reaction_emoji']); ?></span>
                                    <?php endif; ?>
                                </div>
                                
                                <?php if(isset($notification->data['post_content_preview'])): ?>
                                    <div class="notification-preview">
                                        "<?php echo e($notification->data['post_content_preview']); ?>"
                                    </div>
                                <?php endif; ?>
                                
                                <div class="notification-meta">
                                    <span class="notification-time"><?php echo e($notification->created_at->diffForHumans()); ?></span>
                                    
                                    <?php if(!$notification->read_at): ?>
                                        <span class="notification-status unread">Unread</span>
                                    <?php else: ?>
                                        <span class="notification-status read">Read</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div class="notification-actions">
                            <?php if(!$notification->read_at): ?>
                                <form action="<?php echo e(route('notifications.read', $notification->id)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-secondary btn-sm">
                                        Mark Read
                                    </button>
                                </form>
                            <?php endif; ?>
                            
                            <?php if(isset($notification->data['url'])): ?>
                                <form action="<?php echo e(route('notifications.read', $notification->id)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="redirect_url" value="<?php echo e($notification->data['url']); ?>">
                                    <button type="submit" class="btn btn-primary btn-sm">
                                        <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M9 18l6-6-6-6"></path>
                                        </svg>
                                        View
                                    </button>
                                </form>
                            <?php endif; ?>
                            
                            <form action="<?php echo e(route('notifications.destroy', $notification->id)); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" 
                                        onclick="return confirm('Are you sure you want to delete this notification?')"
                                        class="btn btn-link btn-sm">
                                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <polyline points="3,6 5,6 21,6"></polyline>
                                        <path d="m19,6v14a2,2 0 0,1 -2,2H7a2,2 0 0,1 -2,-2V6m3,0V4a2,2 0 0,1 2,-2h4a2,2 0 0,1 2,2v2"></path>
                                    </svg>
                                    Delete
                                </button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="notifications-pagination">
                <?php echo e($notifications->links()); ?>

            </div>
        <?php else: ?>
            <div class="notifications-content">
                <div class="notifications-empty">
                    <div class="empty-icon">🔔</div>
                    <h3 class="empty-title">No notifications yet</h3>
                    <p class="empty-description">
                        You'll see notifications here when someone interacts with your posts or threads. 
                        Start engaging with the community to get notified!
                    </p>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
// Auto-refresh unread count every 30 seconds
setInterval(function() {
    fetch('<?php echo e(route('notifications.unread-count')); ?>')
        .then(response => response.json())
        .then(data => {
            const badge = document.querySelector('.notification-badge');
            if (badge) {
                badge.textContent = data.count;
                badge.classList.toggle('hidden', data.count === 0);
            }
        })
        .catch(error => console.error('Error updating notification count:', error));
}, 30000);
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/notifications/index.blade.php ENDPATH**/ ?>